/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.tileentities;

import com.zkryle.jeg.common.ICoreOwner;
import com.zkryle.jeg.core.Init;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChargingTableBlockEntity
extends BlockEntity
implements ICoreOwner {
    protected ItemStack core = ItemStack.EMPTY;
    private short charge = 0;
    private short rotationAnim = 0;
    private byte soundTick = 0;

    protected ChargingTableBlockEntity(BlockEntityType<?> typeIn, BlockPos pWorldPosition, BlockState pBlockState) {
        super(typeIn, pWorldPosition, pBlockState);
    }

    public ChargingTableBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this((BlockEntityType)Init.CHARGING_TABLE_BLOCK_ENTITY_TYPE.get(), pWorldPosition, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChargingTableBlockEntity blockEntity) {
        if (level.isClientSide()) {
            if (blockEntity.rotationAnim < 360) {
                if (blockEntity.getCorePercentage() > 10.0f) {
                    blockEntity.rotationAnim = (short)((float)blockEntity.rotationAnim + blockEntity.getCorePercentage() / 10.0f);
                }
            } else {
                blockEntity.resetRotationAnim();
            }
        }
        if (blockEntity.hasCore()) {
            if (blockEntity.charge > 0) {
                if (blockEntity.getCore().getDamageValue() > 0) {
                    blockEntity.getCore().setDamageValue(blockEntity.core.getDamageValue() - 1);
                }
                blockEntity.charge = (short)(blockEntity.charge - 1);
            }
            if (blockEntity.soundTick == 0) {
                blockEntity.playLoop();
                blockEntity.soundTick = (byte)105;
            }
            blockEntity.soundTick = (byte)(blockEntity.soundTick - 1);
            blockEntity.soundTick = (byte)Math.max(0, blockEntity.soundTick);
        } else {
            if (blockEntity.soundTick == 0) {
                blockEntity.playLoopEnd();
            }
            blockEntity.soundTick = (byte)(blockEntity.soundTick - 1);
            blockEntity.soundTick = (byte)Math.max(-1, blockEntity.soundTick);
        }
    }

    protected void saveAdditional(CompoundTag pCompound) {
        CompoundTag core = new CompoundTag();
        this.core.save(core);
        pCompound.putShort("CHARGE", this.charge);
        pCompound.put("CORE", (Tag)core);
        System.out.println(pCompound);
    }

    public void load(CompoundTag pCompound) {
        System.out.println(pCompound);
        System.out.println("\npenis\n" + pCompound.get("CORE"));
        this.setCore(ItemStack.of((CompoundTag)((CompoundTag)pCompound.get("CORE"))).copy());
        this.setCharge(pCompound.getShort("CHARGE"));
        super.load(pCompound);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        this.setChanged();
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.getTag();
        this.load(tag);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition).getBlock().defaultBlockState(), this.level.getBlockState(this.worldPosition), 2);
    }

    @Override
    public boolean hasCore() {
        return !this.core.isEmpty();
    }

    public ItemStack getCore() {
        return this.core;
    }

    public void setCore(ItemStack core) {
        this.core = core;
        this.setChanged();
        if (!core.isEmpty()) {
            this.soundTick = 0;
        }
    }

    @Override
    public boolean isDelayElapsed() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public short getRotationAnim() {
        return this.rotationAnim;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resetRotationAnim() {
        this.rotationAnim = 0;
    }

    public short getCharge() {
        return this.charge;
    }

    public void setCharge(short charge) {
        this.charge = charge;
    }

    private void playLoop() {
        if (!this.level.isClientSide()) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)Init.CHARGING_STATION_LOOP.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
        }
    }

    private void playLoopEnd() {
        if (!this.level.isClientSide()) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)Init.CHARGING_STATION_LOOP_END.get(), SoundSource.BLOCKS, 0.05f, 1.0f);
        }
    }
}

